<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Notification extends Model 
{

    protected $table = 'notifications';
    public $timestamps = true;
    protected $fillable = array('client_id', 'order_id', 'restaurant_id');

    public function client()
    {
        return $this->belongsTo('Client');
    }

    public function restaurant()
    {
        return $this->belongsTo('Restaurant');
    }

    public function order()
    {
        return $this->belongsTo('Order');
    }

}